from argparse import ArgumentParser
import random

parser = ArgumentParser(description="Create Erdős–Rényi random graphs")

parser.add_argument("-n", type=int)
parser.add_argument("-m", type=int)
parser.add_argument("--seed", type=int, default=0)

args = parser.parse_args()
random.seed(args.seed)
n, m = args.n, args.m
assert n * (n-1)//2 >= m

edges: set[tuple[int, int]] = set()
while len(edges) < m:
    u, v = sorted(random.sample(range(1, n + 1), 2))
    edges.add((u, v))

print(n, m)
for u, v in edges:
    print(u, v)
