#!/usr/bin/env python3
import random
import sys
from argparse import ArgumentParser

parser = ArgumentParser(
    description="Create random instances"
)

parser.add_argument("-n", type=int)
parser.add_argument("-w", type=int)
parser.add_argument("--lo_p", type=int, default=1, help="lower bound on processing time")
parser.add_argument("--hi_p", type=int, default=10**9, help="upper bound on processing time")
parser.add_argument("--lo_t", type=int, default=1, help="lower bound on travel time")
parser.add_argument("--hi_t", type=int, default=10**9, help="upper bound on travel time")
parser.add_argument("--seed", type=int, default=0)

args = parser.parse_args()
random.seed(args.seed)

n, w = args.n, args.w

print(n, w)
for _ in range(n):
    print(random.randint(args.lo_p, args.hi_p), random.randint(args.lo_t, args.hi_t))
