import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class jeroenb {
	static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

	public static void main(String[] args) throws Exception {
		// Read input
		int n = Integer.valueOf(in.readLine());
		ArrayList<Integer>[] nums = new ArrayList[n];
		for (int i = 0; i < n; i++) {
			nums[i] = new ArrayList<Integer>();
			String[] ps = in.readLine().split(" ");
			for (int j = 1; j < ps.length; j++)
				nums[i].add(Integer.valueOf(ps[j]));
		}

		// Idea from README, there can only be a limited number of
		// big sets, we take sqrt(M) as the magic cutoff
		int m = 0;
		for(int i = 0; i < n; i++)
			m += nums[i].size();
		int cutoff = (int) Math.round(Math.sqrt(m));

		HashMap<PII, Integer> smallSet = new HashMap<PII, Integer>();
		for (int i = 0; i < n; i++) {
			// We have a big set, so let's check all other numbers against it
			if (nums[i].size() >= cutoff) {
				HashSet<Integer> set = new HashSet<Integer>(nums[i]);
				for (int j = 0; j < n; j++) {
					if (i == j)
						continue;
					int found = -1;
					for (int k : nums[j]) {
						if (set.contains(k)) {
							if (found == -1) {
								found = k;
							} else {
								// Second number found, we have a solution
								System.out.println(found + " " + k + " " + (i + 1) + " " + (j + 1));
								return;
							}
						}
					}
				}
			} else {
				// Small set, so we can enumerate all pairs
				for (int j : nums[i]) {
					for (int k : nums[i]) {
						if (j < k) {
							PII pair = new PII(j, k);
							if (smallSet.containsKey(pair)) {
								// It already existed, so we found a solution
								int other = smallSet.get(pair);
								System.out.println(j + " " + k + " " + (i + 1) + " " + (other + 1));
								return;
							}
							smallSet.put(pair, i);
						}
					}
				}
			}
		}

		// We reached the end, nothing found
		System.out.println("impossible");
	}
}

class PII {
	public int x, y;

	public PII(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	@Override
	public boolean equals(Object o) {
		if (!(o instanceof PII))
			return false;

		PII other = (PII) o;
		return x == other.x && y == other.y;
	}

	
	public int hashCode() {
		return x * 31 + y;
	}
}
