#include <iostream>
#include <vector>
#include <bitset>
#include <map>
using namespace std;
typedef vector<int> vi;
const int N = 100001;
int main() {
    int m; cin >> m;
    vector<bitset<N>> bs(N); 
    map<int,int> mp;
    vi vals;

    auto get = [&](int x) { // coordinate compression.
        if(!mp.count(x)) {
            vals.push_back(x);
            mp.insert({x,mp.size()});
        }
        return mp[x];
    };

    for(int i=0;i<m;++i) {
        bitset<N> mine;
        int k; cin >> k;
        vi A(k);
        for(int& j : A) cin >> j, j = get(j);
        for(int j : A) {
            if((mine & bs[j]).any()) { // j and some other element in set A_i share another set, so they are a good pair! 
                int who = (mine&bs[j])._Find_first();
                for(int other : A) if(bs[other][who]) {

                    cout << vals[j] << ' ' << vals[other] << ' ' << i+1 << ' ' << who+1 << '\n';
                    exit(0);
                }
            }
            mine|=bs[j];
        }
        for(int j : A) {
            bs[j][i]=1; // update bitset of element j, to show it is in set A_i.
        }
    }
    cout << "impossible\n";
}
/*
3     
2 1 2
3 2 3 4
4 1 5 3 6
*/